﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Handel" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Rozliczenie dokumentów sprzedaży</title>
		<script runat="server">

    void Grid_BeforeRow(Object sender, RowEventArgs args) {
        DokumentHandlowy dokument = (DokumentHandlowy)args.Row;
        foreach (Platnosc p in dokument.Platnosci) {
            termin.AddLine(p.Termin);

            if( p.Zwrot ) {
                kwota.AddLine(-p.Kwota);
                pozostaje.AddLine(-p.DoRozliczenia);
            }
            else {
                kwota.AddLine(p.Kwota);
                pozostaje.AddLine(p.DoRozliczenia);
            }
            
            sposob.AddLine(p.SposobZaplaty);
        }
    }

		</script>
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" Landscape="True"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" title="Rozliczenie dokumentów sprzedaży|</STRONG>Definicja:<STRONG> {1}|</STRONG>Okres:<STRONG> {2}|</STRONG>Magazyn:<STRONG> {3}|</STRONG>Kontrahent:<STRONG> {4}"
				runat="server" DataMember1="DokHandloweViewInfo+WParams.Definicja"
				DataMember2="DokHandloweViewInfo+WParams.Okres" DataMember3="DokHandloweViewInfo+WParams.Magazyn"
				DataMember4="DokHandloweViewInfo+WParams.Kontrahent"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" OnBeforeRow="Grid_BeforeRow" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="18" Align="Left" DataMember="Numer" Caption="Dokument~Numer" VAlign="Top" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Center" DataMember="Data" Caption="Dokument~Data" VAlign="Top" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Align="Left" DataMember="Kontrahent" Caption="Dokument~Kontrahent" VAlign="Top" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Caption="Płatności~Spos&#243;b" ID="sposob" NoWrap="True" VAlign="Top" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Center" Caption="Płatności~Termin" ID="termin" VAlign="Top" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="14" Align="Right" Total="Sum" Caption="Płatności~Kwota" ID="kwota" VAlign="Top" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="14" Align="Right" Total="Sum" Caption="Płatności~Pozostaje" ID="pozostaje"
						VAlign="Top" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="14" Align="Right" DataMember="Suma.Netto" Total="Sum" Caption="Wartość dokumentu~Netto"
						Format="{0:n}" VAlign="Top" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="10" Align="Right" DataMember="Suma.VAT" Total="Sum" Caption="Wartość dokumentu~VAT"
						Format="{0:n}" VAlign="Top" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="14" Align="Right" DataMember="Suma.Brutto" Total="Sum" Caption="Wartość dokumentu~Brutto"
						Format="{0:n}" VAlign="Top" EncodeHTML="True" runat="server"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</form>
	</body>
</HTML>

